module net.BurtonRadons.dig.platform.base;

/+
#ifdef DoxygenMustSkipThis
+/

private import std.c.windows.windows;


private import std.ctype;
private import std.math;
private import std.random;
private import std.string;

private import std.c.stdio;
private import std.utf;
private import std.stream;
private import std.file;
private import std.thread;

//private import std.c.windows.windows;

//import net.BurtonRadons.dig.std;

//private import std.ctype; /* used for isspace */
//private import string; /* used for std.string.toStringz */
//import std.c.stdio; /* used for va_list */

//private import std.math;
//private import std.random;
//private import std.utf;

wchar [] toWStringz (char [] string)
{
    wchar [] result;
    
    result = std.utf.toUTF16 (std.string.toStringz (string) [0 .. string.length + 1]);
    return result [0 .. result.length - 1];
}

wchar [] toWStringz (char *string)
{
    return toWStringz (string [0 .. std.string.strlen (string)]);
}

char [] wtoStringz (wchar [] string)
{
    char [] result = new char [string.length + 1];
    int d;

    for (int c; c < string.length; c ++)
    {
        if (string [c] < 256)
            result [d ++] = string [c];
    }

    return result [0 .. d];
}

char [] wtoStringz (wchar *string)
{
    int length = 0;

    if (string === null)
        return null;

    for (int c; ; c ++)
        if (string [c] == 0)
            return wtoStringz (string [0 .. c]);
}

/** Format a string with printf and return an allocated copy. */
extern (C)
char [] fmt (char [] format, ...)
{
    return fmtf (format, cast (va_list) (&format + 1));
}

/** Format a string with printf and return an allocated copy. */
extern (C)
char [] fmtf (char [] format, va_list args)
{
    char [4096] buffer;
    int length;

    length = vsprintf (buffer, std.string.toStringz (format), args);
    return buffer [0 .. length].dup;
}

/** Get the absolute value of an integer. */
int iabs (int a) { return a < 0 ? -a : a; }

int imid (int min, int value, int max) { return value < min ? min : value > max ? max : value; }

/** Get the maximum value of two integers. */
int imax (int a, int b) { return a > b ? a : b; }

/** Get the maximum value of three integers. */
int imax (int a, int b, int c) { int ab = imax (a, b); return ab > c ? ab : c; }

/** Get the maximum value of four integers. */
int imax (int a, int b, int c, int d) { int abc = imax (a, b, c); return abc > d ? abc : d; }

/** Get the maximum value of five integers. */
int imax (int a, int b, int c, int d, int e) { int abcd = imax (a, b, c, d); return abcd > e ? abcd : e; }

/** Get the minimum value of two integers. */
int imin (int a, int b) { return a < b ? a : b; }

/** Get the minimum value of three integers. */
int imin (int a, int b, int c) { int ab = imin (a, b); return ab < c ? ab : c; }

/** Get the minimum value of four integers. */
int imin (int a, int b, int c, int d) { int abc = imin (a, b, c); return abc < d ? abc : d; }

/** Get the minimum value of five integers. */
int imin (int a, int b, int c, int d, int e) { int abcd = imin (a, b, c, d); return abcd < e ? abcd : e; }

/** Get the maximum value of two floats. */
float fmax (float a, float b) { return a > b ? a : b; }

/** Get the maximum value of three floats. */
float fmax (float a, float b, float c) { float ab = fmax (a, b); return ab > c ? ab : c; }

/** Get the maximum value of four floats. */
float fmax (float a, float b, float c, float d) { float abc = fmax (a, b, c); return abc > d ? abc : d; }

/** Get the maximum value of five floats. */
float fmax (float a, float b, float c, float d, float e) { float abcd = fmax (a, b, c, d); return abcd > e ? abcd : e; }

/** Get the minimum value of two floats. */
float fmin (float a, float b) { return a < b ? a : b; }

/** Get the minimum value of three floats. */
float fmin (float a, float b, float c) { float ab = fmin (a, b); return ab < c ? ab : c; }

/** Get the minimum value of four floats. */
float fmin (float a, float b, float c, float d) { float abc = fmin (a, b, c); return abc < d ? abc : d; }

/** Get the minimum value of five floats. */
float fmin (float a, float b, float c, float d, float e) { float abcd = fmin (a, b, c, d); return abcd < e ? abcd : e; }

/** Clamp to a range. */
float fmid (float min, float value, float max) { return value < min ? min : value > max ? max : value; }

import net.BurtonRadons.dig.common.color;
import net.BurtonRadons.dig.common.event;
import net.BurtonRadons.dig.common.dispatcher;
import net.BurtonRadons.dig.common.bindingList;

char [] digPlatformEventGetKeyCode (inout Event event, int wparam)
{
    switch (wparam)
    {
        case VK_NUMPAD0: case VK_NUMPAD1: case VK_NUMPAD2:
        case VK_NUMPAD3: case VK_NUMPAD4: case VK_NUMPAD5:
        case VK_NUMPAD6: case VK_NUMPAD7: case VK_NUMPAD8:
        case VK_NUMPAD9: return fmt ("NumPad%d", wparam - VK_NUMPAD0);
        case VK_LEFT: return "Left";
        case VK_RIGHT: return "Right";
        case VK_UP: return "Up";
        case VK_DOWN: return "Down";
        case VK_HOME: return "Home";
        case VK_END: return "End";
        case VK_NEXT: return "PageDown";
        case VK_PRIOR: return "PageUp";
        case VK_A: case VK_B: case VK_C: case VK_D: case VK_E:
        case VK_F: case VK_G: case VK_H: case VK_I: case VK_J:
        case VK_K: case VK_L: case VK_M: case VK_N: case VK_O:
        case VK_P: case VK_Q: case VK_R: case VK_S: case VK_T:
        case VK_U: case VK_V: case VK_W: case VK_X: case VK_Y:
        case VK_Z: return fmt ("%c", wparam - VK_A + 'A');
        case VK_BACK: return "BackSpace";
        case VK_RETURN: return "Return";
        case VK_SHIFT: return "Shift";
        case VK_SPACE: return "Space";
        case VK_CONTROL: return "Control";
        case VK_DELETE: return "Delete";
        case VK_INSERT: return "Insert";
        case VK_TAB: return "Tab";
        case VK_0: return "0";
        case VK_1: return "1";
        case VK_2: return "2";
        case VK_3: return "3";
        case VK_4: return "4";
        case VK_5: return "5";
        case VK_6: return "6";
        case VK_7: return "7";
        case VK_8: return "8";
        case VK_9: return "9";
        case VK_F1: case VK_F2: case VK_F3: case VK_F4:
        case VK_F5: case VK_F6: case VK_F7: case VK_F8:
        case VK_F9: case VK_F10: case VK_F11: case VK_F12:
        case VK_F13: case VK_F14: case VK_F15: case VK_F16:
        case VK_F17: case VK_F18: case VK_F19: case VK_F20:
        case VK_F21: case VK_F22: case VK_F23: case VK_F24:
            return fmt ("F%d", wparam - VK_F1 + 1);
        case VK_NUMLOCK: return "NumLock";
        case VK_CAPITAL: return "CapsLock";
        case VK_SCROLL: return "ScrollLock";
        case VK_PAUSE: return "Pause";
        case VK_DIVIDE: return "Slash";
        case VK_MULTIPLY: return "Asterisk";
        case VK_SUBTRACT: return "Dash";
        case VK_ADD: return "Plus";
        case VK_DECIMAL: return "Period";
        case VK_CLEAR: return "NoNumLock5";
        case VK_ESCAPE: return "Escape";
        case 91: case 92: case 93:
        case 188: case 189: case 186: case 222: case 187: case 191:
        case 219: case 221: case 190: case 220: case 192: return null;
        default: return null;
            //printf ("%d\n", wparam);
            //throw new Error ("Switch Default digbase.Event.setKeyCode");
    }
}

bit digPlatformEventSetKeyCode (inout Event event, int wparam)
{
    event.keyCode = digPlatformEventGetKeyCode (event, wparam);
    if (event.keyCode == null)
        return false;
    return true;
}

/*
const int VK_BACK = (8);
const int VK_CANCEL = (3);
const int VK_CAPITAL = (20);
const int VK_CLEAR = (12);
const int VK_CONTROL = (17);
const int VK_DELETE = (46);
const int VK_DOWN = (40);
const int VK_END = (35);
const int VK_EXECUTE = (43);
const int VK_HELP = (47);
const int VK_HOME = (36);
const int VK_INSERT = (45);
const int VK_LBUTTON = (1);
const int VK_LEFT = (37);
const int VK_MBUTTON = (4);
const int VK_MENU = (18);
const int VK_NEXT = (34);
const int VK_PRINT = (42);
const int VK_PRIOR = (33);
const int VK_RBUTTON = (2);
const int VK_RETURN = (13);
const int VK_RIGHT = (39);
const int VK_SELECT = (41);
const int VK_SEPARATOR = (108);
const int VK_SHIFT = (16);
const int VK_SNAPSHOT = (44);
const int VK_SPACE = (32);
const int VK_TAB = (9);
const int VK_UP = (38);

const int VK_LSHIFT = (160);
const int VK_LCONTROL = (162);
const int VK_LMENU = (164);
const int VK_RSHIFT = (161);
const int VK_RCONTROL = (163);
const int VK_RMENU = (165);
const int VK_PROCESSKEY = (229);
*/

/+
#ifndef DOXYGEN_SHOULD_SKIP_THIS
+/

import net.BurtonRadons.dig.platform.windows;

void digPlatformCommDlgExtendedError ()
{
    _DWORD err = CommDlgExtendedError ();

    if (!err)
        return;
    switch (err)
    {
        case CDERR_DIALOGFAILURE: throw new Error ("Dialog box could not be created");
        case CDERR_FINDRESFAILURE: throw new Error ("Failed to find a specified resource");
        case CDERR_INITIALIZATION: throw new Error ("Failed during initialization (possibly insufficient memory)");
        case CDERR_LOADRESFAILURE: throw new Error ("Failed to load a specified resource");
        case CDERR_LOADSTRFAILURE: throw new Error ("Failed to load a specified string");
        case CDERR_LOCKRESFAILURE: throw new Error ("Failed to lock a specified resource");
        case CDERR_MEMALLOCFAILURE: throw new Error ("Unable to allocate memory for internal structures");
        case CDERR_MEMLOCKFAILURE: throw new Error ("Unable to lock memory associated with the handle");
        case CDERR_NO_HINSTANCE: throw new Error ("ENABLETEMPLATE flag was set but no HINSTANCE was provided");
        case CDERR_NOHOOK: throw new Error ("ENABLEHOOK flag was set but no hook function was provided");
        case CDERR_NOTEMPLATE: throw new Error ("ENABLETEMPLATE flag was set but no template was provided");
        case CDERR_REGISTERMSGFAIL: throw new Error ("RegisterWindowMessage function returned an error code");
        case CDERR_STRUCTSIZE: throw new Error ("Invalid initialisation struct size");
        case PDERR_CREATEICFAILURE: throw new Error ("Printing failed to create an information context");
        case PDERR_DEFAULTDIFFERENT: throw new Error ("No printer matches the profile provided");
        case PDERR_DNDMMISMATCH: throw new Error ("The data in the DEVMODE and the DEVNAMES structures describe two different printers");
        case PDERR_GETDEVMODEFAIL: throw new Error ("The printer driver failed to initialize a DEVMODE structure");
        case PDERR_INITFAILURE: throw new Error ("The PrintDlg function failed during initialization");
        case PDERR_LOADDRVFAILURE: throw new Error ("The PrintDlg function failed to load the device driver for the specified printer");
        case PDERR_NODEFAULTPRN: throw new Error ("A default printer does not exist");
        case PDERR_NODEVICES: throw new Error ("No printer devices were found");
        case PDERR_PARSEFAILURE: throw new Error ("PrintDlg failed to parse the strings in the [devices] section of the win.ini file");
        case PDERR_PRINTERNOTFOUND: throw new Error ("The [devices] section of the win.ini file did not contain the requested printer");
        case PDERR_RETDEFFAILURE: throw new Error ("The input to PrintDlg is totally screwed up");
        case PDERR_SETUPFAILURE: throw new Error ("PrintDlg failed to load the required resources");
        case CFERR_MAXLESSTHANMIN: throw new Error ("The minimum font size is higher than the maximum");
        case CFERR_NOFONTS: throw new Error ("No fonts exist (!)");
        case FNERR_BUFFERTOOSMALL: throw new Error ("The lpStrFile buffer is too small");
        case FNERR_INVALIDFILENAME: throw new Error ("A filename is invalid");
        case FNERR_SUBCLASSFAILURE: throw new Error ("An attempt to subclass a list box failed because we ran out of memory");
        case FRERR_BUFFERLENGTHZERO: throw new Error ("A member of the FINDREPLACE structure points to an invalid buffer");
        default:
            printf ("%d, %X\n", err, err);
            throw new Error ("unrecognised CommDlgExtendedError");
    }
}

void digPlatformGetLastError (char [] where)
{
    digPlatformGetLastError (where, GetLastError ());
}

/* Get and check the error */
void digPlatformGetLastError (char [] where, _DWORD dwLastError)
{
    _HMODULE hModule = (HMODULE) 0; // default to system source
    _LPSTR MessageBuffer;
    _DWORD dwBufferLength;

    _DWORD dwFormatFlags = FORMAT_MESSAGE_ALLOCATE_BUFFER |
        FORMAT_MESSAGE_IGNORE_INSERTS |
        FORMAT_MESSAGE_FROM_SYSTEM ;

    //
    // If dwLastError is in the network range, 
    //  load the message source.
    //

    /*if(dwLastError >= NERR_BASE && dwLastError <= MAX_NERR) {
        hModule = LoadLibraryEx(
            TEXT("netmsg.dll"),
            NULL,
            LOAD_LIBRARY_AS_DATAFILE
            );

        if(hModule != NULL)
            dwFormatFlags |= FORMAT_MESSAGE_FROM_HMODULE;
    }*/

    //
    // Call FormatMessage() to allow for message 
    //  text to be acquired from the system 
    //  or from the supplied module handle.
    //

    VA_LIST list;

    if((dwBufferLength = FormatMessageA(
        dwFormatFlags,
        (void *) hModule, // module to get message from (NULL == system)
        dwLastError,
        MAKELANGID(LANG_NEUTRAL, SUBLANG_DEFAULT), // default language
        (char *) (LPSTR) &MessageBuffer,
        (uint) 0,
        list
        )) != 0)
    {
        _DWORD dwBytesWritten;

        Object error = new Error (where ~ ": " ~ MessageBuffer [0 .. dwBufferLength]);

        LocalFree ((_HANDLE) MessageBuffer);
        throw error;
    }

    //
    // If we loaded a message source, unload it.
    //
    if(hModule != (HMODULE) 0)
        FreeLibrary(hModule);
}

real digCommonStringToReal (char [] string)
{
    char [] after;
    return digCommonStringToReal (string, after);
}

real digCommonStringToReal (char [] s, out char [] o)
{
    real value = 0, sign = 1;
    real num = 0, den = 1;

    if (!s.length)
        throw new Error ("String is empty.");

    while (s.length && isspace (s [0]))
        s = s [1 .. s.length];

    if (!s.length)
        throw new Error ("String is full of whitespace.");

    if (s [0] == '-')
        sign = -1, s = s [1 .. s.length];
    else if (s [0] == '+')
        sign = +1, s = s [1 .. s.length];

    if (!s.length)
        throw new Error ("String is just a sign followed by nothing.");

    if (s [0] == '.')
        goto dot;

    if (s [0] < '0' || s [0] > '9')
        throw new Error ("String has no numeric content.");

    while (s.length && s [0] >= '0' && s [0] <= '9')
    {
        value = value * 10 + (s [0] - '0');
        s = s [1 .. s.length];
    }

dot:
    if (s.length && s [0] == '.')
    {
        s = s [1 .. s.length];
        while (s.length && s [0] >= '0' && s [0] <= '9')
        {
            num = num * 10 + (s [0] - '0');
            den = den * 10;
            s = s [1 .. s.length];
        }
    }

    o = s;
    return (value + num / den) * sign;
}

/* A splitlines version that returns ["a", "b", ""] from "a\nb\n", base stolen from Walter. */
char [] [] digCommonFullSplitLines (char [] s)
{
    uint i;
    uint istart;
    uint nlines;
    char[][] lines;

    nlines = 0;
    for (i = 0; i < s.length; i++)
    {	
        char c;

	    c = s[i];
	    if (c == '\r' || c == '\n')
	    {
	        nlines ++;
	        istart = i + 1;
	        if (c == '\r' && i + 1 < s.length && s[i + 1] == '\n')
	        {
		        i ++;
		        istart ++;
	        }
	    }
    }

    //if (istart != i)
	    nlines++;

    lines = new char [] [nlines];
    nlines = 0;
    istart = 0;
    for (i = 0; i < s.length; i ++)
    {
        char c;

	    c = s[i];
	    if (c == '\r' || c == '\n')
	    {
	        lines [nlines] = s [istart .. i];
	        nlines ++;
	        istart = i + 1;
	        if (c == '\r' && i + 1 < s.length && s[i + 1] == '\n')
	        {
		        i ++;
		        istart ++;
	        }
	    }
    }

    //if (istart != i)
    {	
        lines[nlines] = s[istart .. i];
	    nlines ++;
    }

    assert (nlines == lines.length);
    return lines;
}

unittest
{
    char[] s = "\rpeter\n\rpaul\r\njerry\n";
    char[][] lines;
    int i;

    lines = digCommonFullSplitLines (s);
    assert(lines.length == 6);
    assert(lines[0].length == 0);
    i = cmp(lines[1], "peter");
    assert(i == 0);
    assert(lines[2].length == 0);
    i = cmp(lines[3], "paul");
    assert(i == 0);
    i = cmp(lines[4], "jerry");
    assert(i == 0);
    i = cmp(lines [5], "");
    assert (i == 0);

    s = s[0 .. s.length - 1];	// lop off trailing \n
    lines = digCommonFullSplitLines(s);
    assert(lines.length == 5);
    i = cmp(lines[4], "jerry");
    assert(i == 0);
}

char[] digCommonGetBaseName (char [] fullname)
    out (result)
    {
	    assert(result.length <= fullname.length);
    }
    body
    {
	    uint i;

	    for (i = fullname.length; i > 0; i--)
	    {
	        version(Win32)
	        {
		        if (fullname[i - 1] == ':' || fullname[i - 1] == '\\')
		            break;
	        }
	        version(linux)
	        {
		        if (fullname[i - 1] == '/')
		            break;
	        }
	    }
	    return fullname[i .. fullname.length];
    }

float digCommonFloatAbs (float b)
{
    return b > 0 ? b : -b;
}

/+
#endif
+/
